<?php
require_once __DIR__ . '/includes/auth.php';

require_login();
$me = current_user();

/* ----- AJAX: register log + update company last fields ----- */
if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '')==='log_send') {
  header('Content-Type: application/json; charset=utf-8');

  $id_companies = (int)($_POST['id_companies'] ?? 0);

  // Load company and enforce access + wrong flag server-side
  $st = $pdo->prepare("SELECT * FROM companies WHERE id = :id LIMIT 1");
  $st->execute([':id'=>$id_companies]);
  $co = $st->fetch();
  if (!$co) { echo json_encode(['ok'=>false,'error'=>'not found']); exit; }
  if (!can_access_company_row($co, $me)) { http_response_code(403); echo json_encode(['ok'=>false,'error'=>'forbidden']); exit; }
  if (!empty($co['wrong'])) { echo json_encode(['ok'=>false,'error'=>'email marked wrong']); exit; }

  $id_templates = (int)($_POST['id_templates'] ?? 0);
  $language     = trim($_POST['language'] ?? '');
  $title_nr     = (int)($_POST['title_nr'] ?? 1);
  $ref          = trim($_POST['ref'] ?? '');

  $pdo->prepare("INSERT INTO log (id_companies,id_templates,language,title_nr,ref,timestamp)
                 VALUES (:c,:t,:l,:n,:r,NOW())")
      ->execute([':c'=>$id_companies, ':t'=>$id_templates, ':l'=>$language, ':n'=>$title_nr, ':r'=>$ref]);

  $pdo->prepare("UPDATE companies
                   SET last_date = NOW(),
                       last_template = :lt,
                       history = CASE WHEN history IS NULL OR history=''
                                      THEN :h
                                      ELSE CONCAT(history, '\n', :h) END
                 WHERE id = :id")
      ->execute([
        ':lt' => $ref . '-' . $language,
        ':h'  => $ref . '-' . $language . '-' . date('Y-m-d'),
        ':id' => $id_companies
      ]);

  echo json_encode(['ok'=>true]);
  exit;
}

/* ----- Load company & templates ----- */
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $pdo->prepare("SELECT * FROM companies WHERE id=:id");
$stmt->execute([':id'=>$id]);
$co = $stmt->fetch();
if (!$co) { header('Location: list.php'); exit; }

// Enforce visibility
if (!can_access_company_row($co, $me)) { http_response_code(403); echo "Forbidden"; exit; }

/* ----- Enhancement #18(a): log when user opens send.php from list ----- */
if (!isset($_SESSION['send_open_logged'])) $_SESSION['send_open_logged'] = [];
$k = (string)$id;
$now = time();
$last = (int)($_SESSION['send_open_logged'][$k] ?? 0);

/* ----- Retiro este registo de log quando se clica send na pagina list ----- */
/*
if ($id > 0 && ($now - $last) > 60) {
  try {
    $pdo->prepare("INSERT INTO log (id_companies,id_templates,language,title_nr,ref,timestamp)
                   VALUES (:c, 0, :l, 0, 'OPEN', NOW())")
        ->execute([
          ':c' => $id,
          ':l' => trim((string)($co['language'] ?? ''))
        ]);
    $_SESSION['send_open_logged'][$k] = $now;
  } catch (Throwable $e) {
    // best-effort
  }
}
*/

$wrong = !empty($co['wrong']);

$language = $co['language'] ?? '';
$tpls = $pdo->prepare("SELECT * FROM templates WHERE language=:l ORDER BY id ASC");
$tpls->execute([':l'=>$language]);
$templates = $tpls->fetchAll();

/* ----- Determine title number to use (SESSION rotation 1→2→3→1 per language) ----- */
if (!isset($_SESSION['title_rotate'])) $_SESSION['title_rotate'] = [];
$use_nr = 1;
if (!isset($_SESSION['title_rotate'][$language])) {
  $_SESSION['title_rotate'][$language] = 1;
} else {
  $_SESSION['title_rotate'][$language] = ($_SESSION['title_rotate'][$language] % 3) + 1;
}
$use_nr = (int)$_SESSION['title_rotate'][$language];

/* ----- Salutation rules ----- */
$mf = trim($co['mf'] ?? '');
$name = trim($co['name'] ?? '');
$last_name = '';
if ($name !== '') { $parts = preg_split('/\s+/', $name); $last_name = end($parts); }
$sal = 'Hi';
$salutations = [
  'fr' => ['M'=>'Bonjour Monsieur','F'=>'Bonjour Madame',''=>'Bonjour'],
  'en' => ['M'=>'Dear Mr.','F'=>'Dear Mrs.',''=>'Hi'],
];
if (isset($salutations[$language])) { $sal = $salutations[$language][$mf] ?? $salutations[$language][''] ?? $sal; }

function title_by_nr($tpl, $nr){
  if ($nr == 1) return $tpl['title1'] ?? '';
  if ($nr == 2) return $tpl['title2'] ?? '';
  return $tpl['title3'] ?? '';
}

include __DIR__ . '/header.php';
?>
<section>
  <div class="toolbar"><div class="brand" style="opacity:.8">send</div></div>

  <style>
    /* Enhancement #19: Encapsulate email preview in a large rounded rectangle */
    .mail-panel{
      border:1px solid var(--control-border, rgba(255,255,255,.20));
      background: var(--control-bg, rgba(255,255,255,.04));
      border-radius: 18px;
      padding: 14px;
      box-shadow: var(--shadow);
      margin-top: 10px;
      max-width: 980px;
    }
    .mail-panel .subject{
      font-weight: 800;
      margin: 0 0 10px 0;
      white-space: normal;
      overflow-wrap: anywhere;
    }
    .mail-panel pre{
      margin: 0;
      white-space: pre-wrap;         /* wrap text */
      overflow-wrap: anywhere;       /* break long tokens */
      word-break: break-word;
      max-height: 52vh;
      overflow: auto;
      padding: 10px;
      border-radius: 14px;
      border: 1px solid var(--control-border, rgba(255,255,255,.20));
      background: rgba(0,0,0,0);
    }
    body.theme-white .mail-panel pre{
      background: rgba(255,255,255,.55);
    }
  </style>

  <h3>Send to: <?= htmlspecialchars($co['company_name'] ?? '') ?> — <?= htmlspecialchars($co['email'] ?? '') ?></h3>

  <?php if ($wrong): ?>
    <p class="note" style="border-color:#b33;">
      This record is marked as <strong>wrong email</strong>. Sending is disabled until “wrong” is cleared in the list.
    </p>
  <?php endif; ?>

  <form id="sendForm" onsubmit="return false">
    <div>
      <?php foreach ($templates as $t):
        $ref = $t['ref'] ?? '';
        $title_txt = title_by_nr($t, $use_nr);
        $label = '#' . $use_nr . ' [' . $ref . '] title' . $use_nr . ' - ' . $title_txt;
      ?>
      <div style="margin:6px 0">
        <label>
          <input type="radio"
                 name="tpl"
                 value="<?= (int)$t['id'] ?>"
                 data-ref="<?= htmlspecialchars($ref) ?>"
                 data-title="<?= htmlspecialchars($title_txt) ?>"
                 required <?= $wrong ? 'disabled' : '' ?>>
          <?= htmlspecialchars($label) ?>
        </label>
      </div>
      <?php endforeach; ?>
      <?php if (empty($templates)): ?>
        <div style="opacity:.7">No templates for language: <?= htmlspecialchars($language) ?></div>
      <?php endif; ?>
    </div>

    <!-- Enhancement #19: the whole email content is inside this container -->
    <div class="mail-panel" id="mailPanel">
      <div id="previewSubject" class="subject">Subject:</div>
      <pre id="previewText"></pre>
    </div>

    <!-- Buttons are outside the rounded container (per your spec) -->
    <div style="margin-top:10px">
      <button id="btnSend" class="btn primary" type="button" <?= $wrong ? 'disabled' : '' ?>>send</button>
      <a href="list.php" class="btn">cancel</a>
    </div>
  </form>
</section>

<script>
(function(){
  const useNr       = <?= (int)$use_nr ?>;
  const company     = <?= json_encode($co, JSON_HEX_TAG|JSON_HEX_APOS|JSON_HEX_AMP|JSON_HEX_QUOT) ?>;
  const isWrong     = <?= $wrong ? 'true' : 'false' ?>;
  const sal         = <?= json_encode($sal) ?>;
  const lastName    = <?= json_encode($last_name) ?>;
  const previewText = document.getElementById('previewText');
  const previewSubj = document.getElementById('previewSubject');

  let currentSubject = '';
  let currentBody    = '';

  function replaceXXXXX(str, name){
    if (!str) return '';
    try { return str.replace(/XXXXX/gi, name || ''); } catch(e) { return str; }
  }
  function buildGreeting(){
    const coName = company.company_name || '';
    if ((company.mf === 'M' || company.mf === 'F') && lastName) {
      return sal + ' ' + lastName + ',\n\n';
    }
    return sal + (sal.endsWith('.') ? '' : '.') + (coName ? '\n\n' : '\n\n');
  }
  async function fetchBody(tplId){
    try{
      const r = await fetch('templates_body.php?id='+encodeURIComponent(tplId));
      const j = await r.json();
      return (j && typeof j.body === 'string') ? j.body : '';
    }catch(_){ return ''; }
  }
  function renderPreview(){
    previewSubj.textContent = 'Subject: ' + currentSubject;
    previewText.textContent = currentBody;
  }

  async function selectTemplate(radio){
    if (!radio) return;

    const tplId      = radio.value;
    const rawTitle   = radio.dataset.title || '';
    const coName     = company.company_name || '';

    currentSubject = replaceXXXXX(rawTitle, coName);

    let body = await fetchBody(tplId);
    body = body.replace(/\r\n/g, '\n');
    body = body.replace(/\+/g, ' ');
    body = replaceXXXXX(body, coName);

    currentBody = buildGreeting() + body;
    renderPreview();
  }

  const radios = Array.from(document.querySelectorAll('input[name="tpl"]'));
  radios.forEach(r => r.addEventListener('change', ()=> selectTemplate(r)));

  if (!radios.find(r => r.checked) && radios.length) {
    radios[0].checked = true;
  }
  const chosenInit = document.querySelector('input[name="tpl"]:checked');
  if (chosenInit) { selectTemplate(chosenInit); }

  document.getElementById('btnSend').addEventListener('click', async ()=>{
    if (isWrong) { alert('Sending is disabled because email is marked wrong.'); return; }

    const chosen = document.querySelector('input[name="tpl"]:checked');
    if (!chosen){ alert('Select a template'); return; }

    const to = (company.email || '').trim();
    if (!to){ alert('No email set for this company'); return; }

    try{
      await fetch('send.php', {
        method:'POST',
        headers:{'Content-Type':'application/x-www-form-urlencoded'},
        body: new URLSearchParams({
          action:'log_send',
          id_companies: company.id,
          id_templates: chosen.value,
          language: company.language || '',
          title_nr: useNr,
          ref: chosen.dataset.ref || ''
        })
      });
    }catch(_){}

    const subject = currentSubject || (chosen.dataset.title || '');
    const bodyCRLF = (currentBody || '').replace(/\r?\n/g, '\r\n');

    const mailto = 'mailto:' + encodeURIComponent(to)
                 + '?subject=' + encodeURIComponent(subject)
                 + '&body=' + encodeURIComponent(bodyCRLF);

    window.location.href = mailto;

    setTimeout(()=>{ window.location.assign('list.php?highlight_id='+encodeURIComponent(company.id)); }, 300);
  });
})();
</script>

<?php include __DIR__ . '/footer.php'; ?>
