<?php
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

require_login();

$me = current_user();
$role = (string)($me['role'] ?? '');
if ($role !== 'admin') {
  http_response_code(403);
  echo "Forbidden";
  exit;
}

// Use backticks defensively for table/column names
$lastId = null;
try {
  $lastId = $pdo->query("SELECT `id_companies` FROM `log` ORDER BY `timestamp` DESC, `id` DESC LIMIT 1")->fetchColumn();
} catch (Throwable $e) {
  $lastId = null;
}

$rows = [];
try {
  $rows = $pdo->query("
    SELECT l.*, c.company_name
      FROM `log` l
      LEFT JOIN companies c ON c.id = l.id_companies
     ORDER BY l.`timestamp` DESC, l.`id` DESC
     LIMIT 1000
  ")->fetchAll();
} catch (Throwable $e) {
  $rows = [];
  $err = $e->getMessage();
}

include __DIR__ . '/header.php';
?>
<section>
  <h2>Log</h2>

  <div class="toolbar" style="margin-top:0">
    <?php if (!empty($lastId)): ?>
      <a class="btn primary" href="list.php?highlight_id=<?= (int)$lastId; ?>">Goto record</a>
    <?php endif; ?>
  </div>

  <?php if (isset($err)): ?>
    <p class="note">Could not load log: <?= htmlspecialchars($err); ?></p>
  <?php endif; ?>

  <div class="table-wrap">
    <table>
      <thead>
        <tr>
          <th>id</th>
          <th>company</th>
          <th>id_companies</th>
          <th>ref</th>
          <th>id_templates</th>
          <th>language</th>
          <th>title_nr</th>
          <th>timestamp</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($rows as $r): ?>
          <tr>
            <td><?= (int)($r['id'] ?? 0); ?></td>
            <td><?= htmlspecialchars($r['company_name'] ?? ''); ?></td>
            <td><?= (int)($r['id_companies'] ?? 0); ?></td>
            <td><?= htmlspecialchars($r['ref'] ?? ''); ?></td>
            <td><?= (int)($r['id_templates'] ?? 0); ?></td>
            <td><?= htmlspecialchars($r['language'] ?? ''); ?></td>
            <td><?= (int)($r['title_nr'] ?? 0); ?></td>
            <td><?= htmlspecialchars((string)($r['timestamp'] ?? '')); ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</section>
<?php include __DIR__ . '/footer.php'; ?>
