<?php
declare(strict_types=1);

$path = basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH));
$CURRENT = basename($path, '.php');
if ($CURRENT === '' || $CURRENT === 'index') $CURRENT = 'list';

function nav_item(string $slug, string $label, string $current): void {
  $active = ($slug === $current) ? 'active' : '';
  echo '<a class="'.$active.'" href="'.$slug.'.php">'.$label.'</a>';
}

// Best-effort auth awareness (do not force auth here; pages handle require_login)
$logged_in = false;
$me = null;
$role = '';

if (function_exists('is_logged_in') && function_exists('current_user')) {
  $logged_in = is_logged_in();
  $me = $logged_in ? current_user() : null;
  $role = (string)($me['role'] ?? '');
}

$hide_nav = ($CURRENT === 'login' || $CURRENT === 'logout' || !$logged_in);
$is_admin = ($role === 'admin');
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Visitor mail by Clebex</title>

  <link rel="icon" href="assets/favicon.ico">
  <link rel="stylesheet" href="includes/ceo.css?v=3">
  <script defer src="includes/app.js?v=3"></script>
</head>
<body>
  <div class="topbar">
    <div class="brand" style="display:flex; align-items:center; gap:10px;">
      <img src="assets/logo.png" alt="logo" style="height:22px; width:auto;">
      <span>Visitor mail by Clebex</span>
    </div>

    <?php if (!$hide_nav): ?>
      <nav class="menu">
        <?php nav_item('list','list',$CURRENT); ?>
        <?php nav_item('kpi','kpi',$CURRENT); ?>
        <?php nav_item('templates','templates',$CURRENT); ?>
        <?php nav_item('import','import',$CURRENT); ?>
        <?php nav_item('export','export',$CURRENT); ?>
        <?php if ($is_admin): ?>
          <?php nav_item('users','users',$CURRENT); ?>
          <?php nav_item('log','log',$CURRENT); ?>
        <?php endif; ?>
        <?php nav_item('help','help',$CURRENT); ?>
      </nav>

      <div class="topbar-right" style="margin-left:auto; display:flex; align-items:center; gap:10px;">
        <?php if ($me): ?>
          <div class="user-badge" style="opacity:.85; font-size:13px; white-space:nowrap;">
            <?= htmlspecialchars((string)($me['name'] ?? ''), ENT_QUOTES, 'UTF-8'); ?>
            <?php if (!empty($me['initials'])): ?>
              <?= ' ' . htmlspecialchars((string)$me['initials'], ENT_QUOTES, 'UTF-8'); ?>
            <?php endif; ?>
            <?php if (!empty($me['role'])): ?>
              <?= ' ' . htmlspecialchars((string)$me['role'], ENT_QUOTES, 'UTF-8'); ?>
            <?php endif; ?>
          </div>
        <?php endif; ?>

        <a class="btn tiny" href="logout.php">logout</a>
        <button id="themeToggle" class="btn tiny theme-toggle" title="toggle background"></button>
      </div>
    <?php else: ?>
      <div style="margin-left:auto;">
        <button id="themeToggle" class="btn tiny theme-toggle" title="toggle background"></button>
      </div>
    <?php endif; ?>
  </div>

  <main class="container">
