<?php
declare(strict_types=1);

require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/auth.php';

require_login();
$me = current_user();

include __DIR__ . '/header.php';
?>

<section class="help">
  <div class="toolbar">
    <div class="brand" style="opacity:.85">help</div>
  </div>

  <!-- One-line index -->
  <div id="top" class="help-index" style="margin:10px 0 14px 0; padding:10px; border-radius:12px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; flex-wrap:wrap; gap:10px; align-items:center;">
      <strong style="opacity:.85">Index:</strong>
      <a href="#list">list</a>
      <a href="#new_record">new_record</a>
      <a href="#fields">fields</a>
      <a href="#templates">templates</a>
      <a href="#import">import</a>
      <a href="#export">export</a>
    </div>
  </div>

  <!-- LIST -->
  <article id="list" style="margin-bottom:18px; padding:14px; border-radius:14px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; align-items:baseline; gap:10px; flex-wrap:wrap;">
      <h2 style="margin:0">list</h2>
      <a href="#top" style="opacity:.8; font-size:13px;">top</a>
    </div>

    <h3 style="margin:12px 0 6px 0;">all countries</h3>
    <p style="margin-top:0;">
      The <strong>all countries</strong> combobox filters the list by the <em>country</em> field. By default, it is set to
      <strong>all countries</strong>, which means no country filter is applied. When you select a specific country, the list
      refreshes automatically and shows only records with that country value.
    </p>

    <h3 style="margin:12px 0 6px 0;">all status</h3>
    <p style="margin-top:0;">
      The <strong>all status</strong> combobox filters the list by the <em>status</em> field. Status values represent the
       pipeline steps (Prospect, Email Sent, Follow-up, etc.). Selecting a status
      refreshes the list automatically. Leaving it on <strong>all status</strong> applies no status filter.
    </p>

    <h3 style="margin:12px 0 6px 0;">all groups</h3>
    <p style="margin-top:0;">
      The <strong>all groups</strong> combobox filters the list by the <em>grupo</em> field. Groups are user-defined tags used
      to segment contacts for campaigns, verticals, or any custom classification you find useful. The options in this list
      are built from the values currently stored in the database.
    </p>

    <h3 style="margin:12px 0 6px 0;">all sectors</h3>
    <p style="margin-top:0;">
      The <strong>all sectors</strong> combobox filters the list by the <em>sector</em> field. Sectors are also user-defined
      and are typically used to categorize companies (e.g., SaaS, Manufacturing, Retail, Healthcare). The options are derived
      from values already present in the companies table.
    </p>

    <h3 style="margin:12px 0 6px 0;">combined filtering</h3>
    <p style="margin-top:0;">
      Filtering is always <strong>combined</strong>. That means the visible list is the intersection of the four selections:
      <em>country AND status AND group AND sector</em>. Any selection change in any combobox triggers an immediate refresh.
      To remove all filters, use the <strong>all</strong> reset button.
    </p>

    <h3 style="margin:12px 0 6px 0;">reset (all)</h3>
    <p style="margin-top:0;">
      The <strong>all</strong> button resets all four comboboxes back to their default “all …” values, effectively clearing
      all filtering and returning to the full list you are allowed to see under your role permissions.
    </p>

    <h3 style="margin:12px 0 6px 0;">search box</h3>
    <p style="margin-top:0;">
      The search box filters by a free-text match across multiple fields. Typing will refresh the list automatically after a
      brief pause. Clearing the search will restore the results for the currently selected filters.
    </p>

    <h3 style="margin:12px 0 6px 0;">send button</h3>
    <p style="margin-top:0;">
      The <strong>send</strong> button opens the email preparation workflow for the selected record.
      If <em>wrong email</em> is checked (the <code>wrong</code> field is set), the send action is disabled for that record
      to prevent sending to an invalid address.
    </p>
  </article>

  <!-- NEW RECORD -->
  <article id="new_record" style="margin-bottom:18px; padding:14px; border-radius:14px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; align-items:baseline; gap:10px; flex-wrap:wrap;">
      <h2 style="margin:0">new_record</h2>
      <a href="#top" style="opacity:.8; font-size:13px;">top</a>
    </div>

    <h3 style="margin:12px 0 6px 0;">adding a new record</h3>
    <p style="margin-top:0;">
      Click the <strong>add</strong> button (top-right). A pop-up form opens with the fields in the same order as they are
      displayed in the list. Enter the information and click <strong>save</strong>. There is no need to enter information in all fields.
    </p>

    <h3 style="margin:12px 0 6px 0;">hints in the new record form</h3>
    <p style="margin-top:0;">
      Some fields include on-screen guidance:
    </p>
    <ul style="margin-top:0;">
      <li><strong>grupo</strong>: user defined group for easier filtering.</li>
      <li><strong>language</strong>: example: en, de, fr, …</li>
      <li><strong>sector</strong>: user defined sector for easier filtering.</li>
      <li><strong>wrong</strong>: labeled as “wrong (if the email is incorrect)” to prevent accidental sending.</li>
    </ul>

    <h3 style="margin:12px 0 6px 0;">best practice</h3>
    <p style="margin-top:0;">
      When creating a record, start by completing the key delivery fields first (company name, contact name, email, language,
      status), then use group/sector to keep filtering and segmentation effective. Finally, use comments to capture
      actions taken and outcomes.
    </p>
  </article>

  <!-- FIELDS -->
  <article id="fields" style="margin-bottom:18px; padding:14px; border-radius:14px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; align-items:baseline; gap:10px; flex-wrap:wrap;">
      <h2 style="margin:0">fields</h2>
      <a href="#top" style="opacity:.8; font-size:13px;">top</a>
    </div>

    <p style="margin-top:10px;">
      The companies table stores contact and workflow information used for outreach campaigns. Below is a practical guide to
      each field as used by the application.
    </p>

    <ul>
      <li><strong>company_name</strong>: The company’s name (primary identifier used throughout the list).</li>
      <li><strong>name</strong>: The contact’s name used in messages.</li>
      <li><strong>mf</strong>: Contact gender marker (commonly “M” or “F”) used for salutations where applicable.</li>
      <li><strong>email</strong>: The contact’s email address used for sending. Accuracy is critical.</li>
      <li><strong>wrong</strong>: Boolean flag indicating the email is incorrect. When enabled, sending is disabled for that record.</li>
      <li><strong>linkedin</strong> (stored as <code>linkedIn</code>): LinkedIn company/contact link or LinkedIn path. Used by the “link” action.</li>
      <li><strong>status</strong>: Pipeline stage, controlled by the status dropdown (values come from an application table).</li>
      <li><strong>language</strong>: Language code used to select templates (e.g., en, fr, de). Keep it consistent.</li>
      <li><strong>country</strong>: Country name used for filtering and segmentation.</li>
      <li><strong>hq_city</strong>: Headquarters city. Helps personalization and segmentation.</li>
      <li><strong>comment</strong>: Working notes. When you edit the comment, the app automatically inserts a date stamp prefix.</li>
      <li><strong>history</strong>: Longer running log text associated with the company.</li>
      <li><strong>sector</strong>: User-defined sector category for filtering (e.g., SaaS, Logistics, Retail).</li>
      <li><strong>grupo</strong>: User-defined group tag for filtering (campaign group, territory, list name, etc.).</li>
      <li><strong>website</strong>: Company website (stored without protocol in many workflows).</li>
      <li><strong>general_email</strong>: Generic company email (info@, contact@) if relevant.</li>
      <li><strong>last_date</strong>: Date of last action/update or last outreach milestone (used for activity monitoring).</li>
      <li><strong>last_template</strong>: Last template reference used for sending (supports continuity and follow-up workflows).</li>
      <li><strong>initials</strong>: Initials of the user who created/owns the record; used for user-level visibility filtering.</li>
    </ul>

    <h3 style="margin:12px 0 6px 0;">timestamps in comments</h3>
    <p style="margin-top:0;">
      When editing <strong>comment</strong>, the application automatically inserts a timestamp prefix in the format
      <code>YYYY-MM-DD: </code>. If the comment already has text, the timestamp is added on a new line. If you close the edit
      without adding anything after the timestamp, the timestamp is removed to avoid blank entries.
    </p>
  </article>

  <!-- TEMPLATES -->
  <article id="templates" style="margin-bottom:18px; padding:14px; border-radius:14px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; align-items:baseline; gap:10px; flex-wrap:wrap;">
      <h2 style="margin:0">templates</h2>
      <a href="#top" style="opacity:.8; font-size:13px;">top</a>
    </div>

    <p style="margin-top:10px;">
      Templates define the email content used during sending. Each template typically contains titles (subject line variants)
      and a message body. Templates are selected by language and reference (ref), and are used by the sending workflow.
    </p>

    <h3 style="margin:12px 0 6px 0;">language and reference</h3>
    <p style="margin-top:0;">
      Templates typically use:
      <strong>language</strong> (e.g., en, fr, de) and a <strong>ref</strong> (an internal identifier such as “introA”, “followup1”)
      to locate and apply the correct messaging at send time.
    </p>

    <h3 style="margin:12px 0 6px 0;">titles</h3>
    <p style="margin-top:0;">
      Title fields (Title 1, Title 2, Title 3) are used to store short subject variants. The application will rotate the titles automatically to reduce spam.
    </p>

    <h3 style="margin:12px 0 6px 0;">body</h3>
    <p style="margin-top:0;">
      The body field stores the email message itself. It can include line breaks and structured content. In most workflows,
      the sender page will show a preview of the selected subject and body before sending.
    </p>

    <h3 style="margin:12px 0 6px 0;">variable XXXXX replaced by company_name</h3>
    <p style="margin-top:0;">
      You can include the sting XXXXX in all titles and in the body. When the email is prepared the string is replaced by the company name.
    </p>

    <h3 style="margin:12px 0 6px 0;">soft deletion (if enabled)</h3>
    <p style="margin-top:0;">
      If your templates table includes a deletion flag (for example <code>del</code>), templates may be hidden without being
      permanently removed. This allows recovery by admins if needed.
    </p>
  </article>

  <!-- IMPORT -->
  <article id="import" style="margin-bottom:18px; padding:14px; border-radius:14px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; align-items:baseline; gap:10px; flex-wrap:wrap;">
      <h2 style="margin:0">import</h2>
      <a href="#top" style="opacity:.8; font-size:13px;">top</a>
    </div>

    <h3 style="margin:12px 0 6px 0;">purpose</h3>
    <p style="margin-top:0;">
      Import lets you add multiple companies from a file (CSV). This is useful when you receive lead lists or migrate
      data from external sources.
    </p>

    <h3 style="margin:12px 0 6px 0;">field mapping</h3>
    <p style="margin-top:0;">
      Imports may be performed with files that do not contain every column in the database. The importer matches available
      columns and inserts what it can. Missing fields remain empty/default.
    </p>

    <h3 style="margin:12px 0 6px 0;">initials assignment on import</h3>
    <p style="margin-top:0;">
      Imported rows are tagged with <code>initials</code> to ensure consistency.
    </p>

    <h3 style="margin:12px 0 6px 0;">best practice</h3>
    <p style="margin-top:0;">
      Use consistent values for <em>country</em>, <em>sector</em>, and <em>grupo</em> so that the filter comboboxes remain useful.
      After importing, review a sample of records, validate email quality, and set <em>wrong</em> where appropriate.
    </p>

    <h3 style="margin:12px 0 6px 0;">import format</h3>
    <p style="margin-top:0;">
      Use the capability to export your data and use this as a template for a future import. The exported file is in CSV format
      that can be easily read by Excel.
    </p>
  </article>

  <!-- EXPORT -->
  <article id="export" style="margin-bottom:18px; padding:14px; border-radius:14px; border:1px solid rgba(255,255,255,.12); background:rgba(255,255,255,.03);">
    <div style="display:flex; align-items:baseline; gap:10px; flex-wrap:wrap;">
      <h2 style="margin:0">export</h2>
      <a href="#top" style="opacity:.8; font-size:13px;">top</a>
    </div>

    <h3 style="margin:12px 0 6px 0;">purpose</h3>
    <p style="margin-top:0;">
      Export produces a file containing your records in CSV format.
    </p>

  </article>

</section>

<?php include __DIR__ . '/footer.php'; ?>
